import { useHost } from '@inject/graphql/connection/host'
import { useGetFileInfo } from '@inject/graphql/queries/GetFileInfo.generated'
import { downloadFileUrl } from '@inject/shared/config'
import DocViewerComponent from '@inject/shared/document/viewer'
import type { FC } from 'react'

interface DocViewerProps {
  teamId: string
  fileId: string
  inInstructor: boolean
}

const DocViewer: FC<DocViewerProps> = ({ teamId, fileId, inInstructor }) => {
  const { data, loading, error } = useGetFileInfo({
    variables: { fileInfoId: fileId },
  })
  const host = useHost()

  return (
    <DocViewerComponent
      doc={{
        uri: downloadFileUrl(host || '', teamId, fileId, inInstructor),
        fileName: data?.fileInfo?.fileName || '',
        fileType: data?.fileInfo?.fileName.split('.').pop() || 'txt',
      }}
      loading={loading || !data?.fileInfo}
      error={error}
    />
  )
}

export default DocViewer
