import { TextArea } from '@blueprintjs/core'
import type { Dispatch, FC, SetStateAction } from 'react'
import { useCallback } from 'react'

interface ContentAreaProps {
  content: string
  template?: string
  setContent: Dispatch<SetStateAction<string>>
}

const ContentArea: FC<ContentAreaProps> = ({ content, setContent }) => {
  const handleContentChange = useCallback(
    (e: React.ChangeEvent<HTMLTextAreaElement>) => {
      setContent(e.target.value)
    },
    [setContent]
  )

  return (
    <TextArea
      value={content}
      style={{
        resize: 'none',
        overflowY: 'auto',
        flex: 1,
      }}
      placeholder='Message'
      onChange={handleContentChange}
    />
  )
}

export default ContentArea
