/* eslint-disable @typescript-eslint/no-explicit-any */
import { Section, Switch } from '@blueprintjs/core'
import type { makeVar } from '@inject/shared/utils/reactive'
import type { FC } from 'react'

const SwitchSetting: FC<{
  useVar: () => any
  variable: ReturnType<typeof makeVar<any>>
  title: string
  subtitle?: string
  trueValue?: string
  falseValue?: string
}> = ({
  useVar,
  variable,
  title,
  subtitle,
  trueValue = 'Yes',
  falseValue = 'No',
}) => {
  const View = () => {
    const reactiveVar = useVar()
    return (
      <>
        <span>{reactiveVar ? trueValue : falseValue}</span>
        <Switch
          style={{ margin: '0' }}
          checked={reactiveVar}
          onChange={() => variable(!reactiveVar)}
        />
      </>
    )
  }
  return (
    <Section
      title={title}
      subtitle={subtitle}
      rightElement={
        <div style={{ display: 'flex', gap: '0.25rem', alignItems: 'center' }}>
          <View />
        </div>
      }
    />
  )
}

export default SwitchSetting
