import { Section, SectionCard } from '@blueprintjs/core'
import { useHost } from '@inject/graphql/connection/host'
import { useWs } from '@inject/graphql/connection/ws'

const Connection = () => {
  const hostVar = useHost()
  const wsVar = useWs()

  return (
    <Section
      title='Connection'
      subtitle='Current client parameters (set by the administrator)'
    >
      <SectionCard>
        <p>
          Host: <code>{hostVar}</code>
        </p>
        <p>
          Websocket: <code>{wsVar}</code>
        </p>
      </SectionCard>
    </Section>
  )
}

export default Connection
