import { NumericInput } from '@blueprintjs/core'
import SettingsSection from '../SettingsSection'
import useNotificationLimit from './useNotificationLimit'

const NotificationLimit = () => {
  const [limitValue, setLimit] = useNotificationLimit()

  return (
    <SettingsSection
      title='Notifications'
      subtitle='Change the number of notifications to store'
    >
      <NumericInput
        fill
        min={0}
        value={limitValue}
        onValueChange={value => setLimit(value)}
      />
    </SettingsSection>
  )
}

export default NotificationLimit
