import { routes } from '@generouted/react-router'
import ApolloProviderWrapped from '@inject/graphql/client'
import Connection from '@inject/graphql/connection'
import SubscriptionEngine from '@inject/graphql/context'
import PopupEngine from '@inject/shared/popup/PopupEngine'
import { useCallback } from 'react'
import { RouterProvider, createBrowserRouter } from 'react-router-dom'
import useNotificationLimit from './clientsettings/NotificationLimit/useNotificationLimit'

const Application = () => {
  const router = createBrowserRouter(routes)
  const onFailedAuth = useCallback(
    () => (msg: string) => {
      console.log(msg)
      router.navigate('/login')
    },
    [router]
  )

  // settings have to be imported here to sync across tabs
  useNotificationLimit()

  return (
    <Connection host={window.VITE_HTTPS_HOST || 'localhost:8000'}>
      <ApolloProviderWrapped onFailedAuth={onFailedAuth}>
        <SubscriptionEngine>
          <PopupEngine>
            <RouterProvider router={router} />
          </PopupEngine>
        </SubscriptionEngine>
      </ApolloProviderWrapped>
    </Connection>
  )
}

export default Application
