import ExerciseContext from '@/analyst/ExerciseContext'
import { injectEmailTool } from '@/analyst/utilities'
import useEmailsEnabled from '@inject/graphql/utils/useEmailsEnabled'
import { useContext } from 'react'
import useTools from './useTools'

const useToolsWithEmailsSent = () => {
  const { exercise } = useContext(ExerciseContext)
  const tools = useTools()
  const emailsEnabled = useEmailsEnabled({
    variables: { exerciseId: exercise.id },
  })

  return emailsEnabled ? [...tools, injectEmailTool] : tools
}

export default useToolsWithEmailsSent
