import ExerciseContext from '@/analyst/ExerciseContext'
import { useGetToolsSuspenseQuery } from '@inject/graphql/queries/GetTools.generated'
import notEmpty from '@inject/shared/utils/notEmpty'
import { useContext } from 'react'

const useTools = () => {
  const { exercise } = useContext(ExerciseContext)

  const { data: toolsData } = useGetToolsSuspenseQuery({
    variables: { exerciseId: exercise.id },
  })

  return (
    toolsData && toolsData.exerciseTools
      ? toolsData.exerciseTools.filter(notEmpty)
      : []
  ).sort((a, b) => a.name.localeCompare(b.name))
}

export default useTools
