import ExerciseContext from '@/analyst/ExerciseContext'
import { useGetMilestonesSuspenseQuery } from '@inject/graphql/queries/GetMilestones.generated'
import notEmpty from '@inject/shared/utils/notEmpty'
import { useContext } from 'react'

const useMilestones = () => {
  const { exercise } = useContext(ExerciseContext)
  const { data: milestonesData } = useGetMilestonesSuspenseQuery({
    variables: { exerciseId: exercise.id },
  })

  return milestonesData && milestonesData.milestones
    ? milestonesData.milestones.filter(notEmpty)
    : []
}

export default useMilestones
