import ExerciseContext from '@/analyst/ExerciseContext'
import useAnalyticsMilestonesSubscription from '@inject/graphql/utils/useAnalyticsMilestonesSubscription'
import notEmpty from '@inject/shared/utils/notEmpty'
import { useContext } from 'react'

const useMilestoneStates = () => {
  const { exercise } = useContext(ExerciseContext)
  const { data: milestoneStatesData } = useAnalyticsMilestonesSubscription(
    exercise.id
  )

  return milestoneStatesData && milestoneStatesData.analyticsMilestones
    ? milestoneStatesData.analyticsMilestones.filter(notEmpty)
    : []
}

export default useMilestoneStates
