import ExerciseContext from '@/analyst/ExerciseContext'
import useAnalyticsEmailThreadsSubscription from '@inject/graphql/utils/useAnalyticsEmailThreadsSubscription'
import notEmpty from '@inject/shared/utils/notEmpty'
import { useContext } from 'react'

const useEmailThreads = () => {
  const { exercise } = useContext(ExerciseContext)

  const { data: emailThreadsData } = useAnalyticsEmailThreadsSubscription(
    exercise.id
  )

  return emailThreadsData && emailThreadsData.analyticsEmailThreads
    ? emailThreadsData.analyticsEmailThreads.filter(notEmpty)
    : []
}

export default useEmailThreads
