import ExerciseContext from '@/analyst/ExerciseContext'
import { useGetAutoInjectsSuspenseQuery } from '@inject/graphql/queries/GetAutoInjects.generated'
import notEmpty from '@inject/shared/utils/notEmpty'
import { useContext } from 'react'

const useCategories = () => {
  const { exercise } = useContext(ExerciseContext)

  const { data: categoriesData } = useGetAutoInjectsSuspenseQuery({
    variables: { exerciseId: exercise.id },
  })

  return categoriesData?.injects?.filter(notEmpty) || []
}

export default useCategories
