import ExerciseContext from '@/analyst/ExerciseContext'
import useAnalyticsActionLogsSubscription from '@inject/graphql/utils/useAnalyticsActionLogsSubscription'
import notEmpty from '@inject/shared/utils/notEmpty'
import { useContext } from 'react'

const useActionLogs = () => {
  const { exercise } = useContext(ExerciseContext)
  const { data: actionLogsData } = useAnalyticsActionLogsSubscription(
    exercise.id
  )

  return actionLogsData && actionLogsData.analyticsActionLogs
    ? actionLogsData.analyticsActionLogs.filter(notEmpty)
    : []
}

export default useActionLogs
