import { Colors } from '@blueprintjs/colors'
import { Card, Classes } from '@blueprintjs/core'
import { css } from '@emotion/css'
import type { FC } from 'react'

const label = css`
  background-color: ${Colors.LIGHT_GRAY5} !important;
  .${Classes.DARK} & {
    background-color: ${Colors.DARK_GRAY4} !important;
  }

  box-shadow: none !important;

  padding: 0 0 0 0.5rem;
  white-space: nowrap;
  text-overflow: ellipsis;
  display: flex;
  align-items: center;
  flex-grow: 1;
`

interface LabelProps {
  text: string
}

const Label: FC<LabelProps> = ({ text }) => (
  <Card className={label}>{text}</Card>
)

export default Label
