import type { XScale, YScale } from '@/analyst/Plots/ScatterPlot/types'
import { plotDataElement } from '@/analyst/utilities'
import { Tooltip } from '@blueprintjs/core'
import type { FC } from 'react'
import { useRef } from 'react'
import CommandActionLogTooltip from './CommandActionLogTooltip'

interface CommandActionLogProps {
  teamName: string | undefined
  timestamp: string | null
  toolName: string
  color: string
  argument: string
  response: string
  opacity: number
  onClick: () => void
  xScale: XScale
  yScale: YScale
  dotSize: number
}

const CommandActionLog: FC<CommandActionLogProps> = ({
  teamName,
  timestamp,
  toolName,
  color,
  argument,
  response,
  opacity,
  onClick,
  xScale,
  yScale,
  dotSize,
}) => {
  const ref = useRef<SVGCircleElement>(null)

  return (
    <Tooltip
      targetTagName='g'
      content={
        <CommandActionLogTooltip
          teamName={teamName}
          timestamp={timestamp}
          toolName={toolName}
          argument={argument}
          response={response}
        />
      }
      position='right'
    >
      <circle
        ref={ref}
        className={plotDataElement}
        cx={xScale(new Date(timestamp || ''))}
        cy={yScale(toolName)}
        r={dotSize / 2}
        fill={color}
        opacity={opacity}
        onClick={onClick}
      />
    </Tooltip>
  )
}

export default CommandActionLog
