import type { TeamWithoutEmailAddress } from '@inject/graphql/fragments/TeamWithoutEmailAddress.generated'
import type { Tool } from '@inject/graphql/fragments/Tool.generated'
import type { ScaleOrdinal } from 'd3-scale'
import type { ReactNode } from 'react'
import type { XScale, YScale } from './ScatterPlot/types'

export interface PlotDataElement {
  name: string
  value: number
  groupName: string | undefined
  tool?: Tool
  team?: TeamWithoutEmailAddress
}

type BasePlotProps = {
  id: string
  groupNames?: string[]
  selectedGroupName?: string
}

type BarPlotDetails = {
  data: PlotDataElement[]
  colorScale: ScaleOrdinal<string, string, never>
}

export type BarPlotProps = BasePlotProps & BarPlotDetails

export type ScatterPlotDataRenderer = ({
  xScale,
  yScale,
  dotSize,
  height,
}: {
  xScale: XScale
  yScale: YScale
  dotSize: number
  height: number
}) => ReactNode

type ScatterPlotDetails = {
  onResetSelection?: () => void
  legendItems?: ReactNode[]
  dataRenderer: ScatterPlotDataRenderer
}

export type ScatterPlotProps = BasePlotProps & ScatterPlotDetails

type PlotProps = BasePlotProps &
  (
    | {
        type: 'bar'
        details: BarPlotDetails
      }
    | {
        type: 'scatter'
        details: ScatterPlotDetails
      }
  )

export type UnresponsivePlotProps<T extends BarPlotProps | ScatterPlotProps> =
  T & {
    width: number
    height: number
  }

export type ResponsivePlotProps = PlotProps & {
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  dependencies?: any[]
}
