import type { FC } from 'react'
import { useRef } from 'react'
import useDimensions from '../useDimensions'
import BarPlot from './BarPlot'
import ScatterPlot from './ScatterPlot'
import type { ResponsivePlotProps } from './types'

const ResponsivePlot: FC<ResponsivePlotProps> = ({
  id,
  groupNames,
  selectedGroupName,
  type,
  details,
  dependencies = [],
}) => {
  const ref = useRef(null)

  const { width, height } = useDimensions(ref, dependencies)

  return (
    <div ref={ref} style={{ height: '100%', overflow: 'hidden' }}>
      {type === 'bar' ? (
        <BarPlot
          id={id}
          data={details.data}
          groupNames={groupNames}
          selectedGroupName={selectedGroupName}
          colorScale={details.colorScale}
          height={height}
          width={width}
        />
      ) : (
        <ScatterPlot
          id={id}
          groupNames={groupNames}
          selectedGroupName={selectedGroupName}
          legendItems={details.legendItems}
          onResetSelection={details.onResetSelection}
          dataRenderer={details.dataRenderer}
          height={height}
          width={width}
        />
      )}
    </div>
  )
}

export default ResponsivePlot
