import { Classes } from '@blueprintjs/core'
import { css } from '@emotion/css'
import type { FC } from 'react'
import { LEGEND_ELEMENT_SIZE } from '../utilities'

const legendText = css`
  .${Classes.DARK} & {
    fill: #fefffe;
  }
`

interface LegendTextProps {
  text: string
}

const LegendText: FC<LegendTextProps> = ({ text }) => (
  <text className={legendText} x={LEGEND_ELEMENT_SIZE} y={5} textAnchor='start'>
    {text}
  </text>
)

export default LegendText
