import { Tooltip } from '@blueprintjs/core'
import type { MilestoneState } from '@inject/graphql/fragments/MilestoneState.generated'
import type { FC } from 'react'
import { useContext, useRef } from 'react'
import Flag from '../../assets/flag.svg?react'
import type { XScale, YScale } from '../Plots/ScatterPlot/types'
import { plotDataElement } from '../utilities'
import FilterContext from './FilterContext'
import MilestoneTooltip from './MilestoneTooltip'

interface MilestoneIconProps {
  milestone: MilestoneState
  teamName: string
  opacity: number
  onClick: () => void
  xScale: XScale
  yScale: YScale
  dotSize: number
}

const MilestoneIcon: FC<MilestoneIconProps> = ({
  milestone,
  teamName,
  opacity,
  onClick,
  xScale,
  yScale,
  dotSize,
}) => {
  const ref = useRef<SVGSVGElement>(null)

  const { displayMilestones } = useContext(FilterContext)

  return (
    <Tooltip
      targetTagName='g'
      content={<MilestoneTooltip milestone={milestone} />}
      position='right'
    >
      <Flag
        ref={ref}
        className={plotDataElement}
        x={xScale(new Date(milestone.timestampReached || '')) - dotSize / 2}
        y={Number(yScale(teamName)) - dotSize}
        width={dotSize}
        height={dotSize}
        opacity={opacity}
        onClick={onClick}
        style={{ display: displayMilestones ? 'initial' : 'none' }}
      />
    </Tooltip>
  )
}

export default MilestoneIcon
