import { createContext } from 'react'

interface FilterContextProps {
  displayActionLogs: boolean
  displayMilestones: boolean
  displayEmailThreads: boolean
  displayActionType: boolean[]
  displayEmailsSent: boolean
  displayEmailsReceived: boolean
  displayEmailsBetweenTeams: boolean
  displayCategories: boolean
  displayInjectCategories: boolean
  displayEmailCategories: boolean
  displayTool: boolean[]
}

const FilterContext = createContext<FilterContextProps>({
  displayActionLogs: true,
  displayMilestones: true,
  displayEmailThreads: true,
  displayActionType: [],
  displayEmailsSent: true,
  displayEmailsReceived: true,
  displayEmailsBetweenTeams: true,
  displayCategories: true,
  displayInjectCategories: true,
  displayEmailCategories: true,
  displayTool: [],
})

export default FilterContext
