import { NonIdealState } from '@blueprintjs/core'
import { css } from '@emotion/css'
import type { EmailDetails } from '@inject/graphql/fragments/EmailDetails.generated'
import type { FC } from 'react'
import ActionDetail from './ActionDetail'
import CategoryDetail from './CategoryDetail'
import EmailDetail from './EmailDetail'
import MilestoneDetail from './MilestoneDetail'
import type { selectedReducerStateProps } from './selectedReducer'

const nonIdeal = css`
  align-self: center;
`

interface DetailsProps {
  selectedState: selectedReducerStateProps
  displayInjectCategories: boolean
  displayEmailCategories: boolean
}

const Detail: FC<DetailsProps> = ({
  selectedState,
  displayEmailCategories,
  displayInjectCategories,
}) => {
  switch (selectedState.selectedDataType) {
    case 'ACTIONS':
      if (!selectedState.actionLog)
        throw new Error('actionLog null when ACTIONS selected')
      return <ActionDetail actionLog={selectedState.actionLog} />
    case 'MILESTONES':
      if (!selectedState.milestoneState) {
        throw new Error('milestoneState null when MILESTONES selected')
      }
      return <MilestoneDetail milestone={selectedState.milestoneState} />
    case 'EMAILS':
      if (!selectedState.actionLog)
        throw new Error('actionLog null when EMAILS selected')
      if (selectedState.actionLog.type !== 'EMAIL')
        throw new Error("actionLog.type !== 'EMAIL' when EMAILS selected")
      return (
        <EmailDetail
          emailDetails={selectedState.actionLog.details as EmailDetails}
        />
      )
    case 'AUTO_INJECTS':
      if (!selectedState.injectGroup)
        throw new Error('injectGroup null when AUTO_INJECTS selected')
      return (
        <CategoryDetail
          injectGroup={selectedState.injectGroup.filter(
            injectGroup =>
              (displayInjectCategories && injectGroup.type !== 'EMAIL') ||
              (displayEmailCategories && injectGroup.type === 'EMAIL')
          )}
        />
      )
    default:
      return (
        <NonIdealState
          className={nonIdeal}
          icon='search'
          title='No element selected'
          description='Select an element to view detail about'
        />
      )
  }
}

export default Detail
