import { css } from '@emotion/css'
import type { DefinitionInject } from '@inject/graphql/fragments/DefinitionInject.generated'
import type { FC } from 'react'
import { useContext } from 'react'
import ExerciseContext from '../ExerciseContext'
import useFormatTimestamp from '../useFormatTimestamp'
import { MIN_TO_MS } from '../utilities'
import { td, th } from './detailStyles'

const wrapper = css`
  display: flex;
  flex-direction: column;
  gap: 1rem;
`

interface CategoryDetailProps {
  injectGroup: DefinitionInject[]
}

const CategoryDetail: FC<CategoryDetailProps> = ({ injectGroup }) => {
  const { exercise } = useContext(ExerciseContext)
  const formatTimestamp = useFormatTimestamp()

  return (
    <div className={wrapper}>
      {injectGroup.map((inject, i) => (
        <div key={inject.id}>
          {injectGroup.length > 1 && (
            <>
              <em>{`${i}:`}</em>
              <br />
            </>
          )}
          <table>
            <tbody>
              <tr>
                <th className={th}>Name</th>
                <td className={td}>{inject.name}</td>
              </tr>
              <tr>
                <th className={th}>Type</th>
                <td className={td}>{inject.type}</td>
              </tr>
              <tr>
                <th className={th}>Timestamp</th>
                <td className={td}>
                  {formatTimestamp(
                    new Date(
                      (exercise.exerciseStart
                        ? new Date(exercise.exerciseStart).getTime()
                        : 0) +
                        (inject.time + inject.delay) * MIN_TO_MS
                    ).toISOString()
                  )}
                </td>
              </tr>
            </tbody>
          </table>
        </div>
      ))}
    </div>
  )
}

export default CategoryDetail
