import { Button } from '@blueprintjs/core'
import type { FC, PropsWithChildren } from 'react'

interface TabButtonProps extends PropsWithChildren {
  onClick: () => void
  active?: boolean
}

const TabButton: FC<TabButtonProps> = ({ children, onClick, active }) => (
  <Button
    minimal
    style={{
      minWidth: 'fit-content',
    }}
    active={active}
    onClick={onClick}
  >
    {children}
  </Button>
)

export default TabButton
