import useMilestoneStates from '@/analyst/dataHooks/useMilestoneStates'
import { ProgressBar } from '@blueprintjs/core'
import type { Team } from '@inject/graphql/fragments/Team.generated'
import type { FC } from 'react'
import TabButton from '../OverflowTabs/TabButton'
import { getIntent } from '../utilities'

interface TitleProps {
  team: Team | undefined
  onClick: () => void
  active?: boolean
}

const Title: FC<TitleProps> = ({ team, onClick, active }) => {
  const milestoneStates = useMilestoneStates()

  const filteredMilestoneStates = team
    ? milestoneStates.filter(milestoneState =>
        milestoneState.teamIds?.includes(team.id)
      )
    : milestoneStates

  const progress =
    filteredMilestoneStates.filter(
      teamMilestoneState => teamMilestoneState.reached
    ).length / filteredMilestoneStates.length

  return (
    <TabButton active={active} onClick={onClick}>
      <div
        style={{
          display: 'flex',
          flexDirection: 'column',
        }}
      >
        <p style={{ marginBottom: 3, whiteSpace: 'nowrap' }}>
          {team?.name || 'All teams'}
        </p>
        <ProgressBar
          animate={false}
          stripes={false}
          value={progress}
          intent={team && getIntent(progress)}
        />
      </div>
    </TabButton>
  )
}

export default Title
