import { Callout, Classes, H6 } from '@blueprintjs/core'
import { css } from '@emotion/css'
import type { MilestoneState } from '@inject/graphql/fragments/MilestoneState.generated'
import type { Dispatch, FC } from 'react'
import type { selectedReducerActionProps } from '../Overview/selectedReducer'
import useFormatTimestamp from '../useFormatTimestamp'

export const milestoneCard = (isSelected?: boolean) => css`
  flex: 0;
  flex-grow: 0;
  white-space: nowrap;
  text-align: center;
  height: 69;
  cursor: pointer;

  ${isSelected
    ? css`
        box-shadow: 0 0.125rem 0.25rem rgb(17 20 24 / 15%);
      `
    : css`
        &:hover {
          box-shadow: 0 0.125rem 0.25rem rgb(17 20 24 / 10%);
        }

        &:active {
          box-shadow: 0 0.125rem 0.25rem rgb(17 20 24 / 15%);
        }
      `}
`

interface MilestoneCardProps {
  isSelected?: boolean
  milestoneState: MilestoneState
  selectedDispatch: Dispatch<selectedReducerActionProps>
}

const MilestoneCard: FC<MilestoneCardProps> = ({
  isSelected,
  milestoneState,
  selectedDispatch,
}) => {
  const formatTimestamp = useFormatTimestamp()

  return (
    <Callout
      className={milestoneCard(isSelected)}
      intent={milestoneState.reached ? 'success' : undefined}
      icon={null}
      onClick={() =>
        selectedDispatch({ type: 'selectMilestones', milestoneState })
      }
    >
      <H6
        style={{
          marginBottom: 0,
          transform: milestoneState.reached ? undefined : 'translateY(50%)',
        }}
      >
        {milestoneState.milestone.name}
      </H6>
      {milestoneState.reached ? (
        <span className={Classes.TEXT_SMALL}>
          {formatTimestamp(milestoneState.timestampReached)}
        </span>
      ) : (
        ''
      )}
    </Callout>
  )
}

export default MilestoneCard
