import { Classes, Icon, Tooltip } from '@blueprintjs/core'
import { css } from '@emotion/css'
import type { FC } from 'react'

const content = css`
  max-width: clamp(20rem, 90vw, 40rem);
  white-space: pre-wrap;
`

interface HelpIconProps {
  text: string
}

const HelpIcon: FC<HelpIconProps> = ({ text }) => (
  <div style={{ cursor: 'pointer' }}>
    <Tooltip content={<div className={content}>{text}</div>}>
      <Icon icon='help' className={Classes.TEXT_MUTED} />
    </Tooltip>
  </div>
)

export default HelpIcon
