import type { Exercise } from '@inject/graphql/fragments/Exercise.generated'
import type { ExerciseConfig } from '@inject/graphql/fragments/ExerciseConfig.generated'
import { createContext } from 'react'
import { DUMMY_EXERCISE, DUMMY_EXERCISE_CONFIG } from './utilities'

interface ExerciseContextProps {
  exercise: Exercise
  exerciseConfig: ExerciseConfig
}

const ExerciseContext = createContext<ExerciseContextProps>({
  exercise: DUMMY_EXERCISE,
  exerciseConfig: DUMMY_EXERCISE_CONFIG,
})

export default ExerciseContext
