import { Button, Collapse } from '@blueprintjs/core'
import type { Tool } from '@inject/graphql/fragments/Tool.generated'
import type { FC } from 'react'
import { useState } from 'react'
import GrapheneForm from './components/GrapheneForm'

interface ToolActionProps {
  grapheneTool: Tool
  teamId: string
  disabled?: boolean
  disabledTitle?: string
}

const ToolAction: FC<ToolActionProps> = ({
  grapheneTool,
  teamId,
  disabled,
  disabledTitle,
}) => {
  const [open, setOpen] = useState<boolean>(false)
  const { tooltipDescription } = grapheneTool
  const newName = grapheneTool.name?.split('_')[1] ?? grapheneTool.name

  return (
    <>
      <Button
        fill
        minimal
        alignText='left'
        icon='sensor'
        text={newName || 'Unknown'}
        onClick={() => setOpen(prev => !prev)}
        title={tooltipDescription || 'No description'}
      />
      <Collapse isOpen={open}>
        <GrapheneForm
          grapheneTool={grapheneTool}
          teamId={teamId}
          setOpen={setOpen}
          disabled={disabled}
          disabledTitle={disabledTitle}
        />
      </Collapse>
    </>
  )
}

export default ToolAction
