import FileViewRedirectButton from '@/components/FileViewRedirectButton'
import { css } from '@emotion/css'
import type { ToolDetails } from '@inject/graphql/fragments/ToolDetails.generated'
import { forwardRef } from 'react'

const wrapper = css`
  display: flex;
  flex-direction: column;
  align-items: flex-start;
  height: 100%;
  width: 100%;
  gap: 0.5rem;
`

const emphasized = css`
  font-weight: bold;
`

interface ToolContentProps {
  details: ToolDetails
  teamId: string
  exerciseId: string
  inInstructor: boolean
}

// eslint-disable-next-line react/display-name
const ToolContent = forwardRef<HTMLDivElement, ToolContentProps>(
  ({ details, teamId, exerciseId, inInstructor }, ref) => (
    <div className={wrapper}>
      <div className={emphasized}>argument:</div>
      <div>{details.argument}</div>
      <div />
      <div className={emphasized}>response:</div>
      <div
        dangerouslySetInnerHTML={{
          __html: details.content.rendered,
        }}
        ref={ref}
      />
      {details.content.fileInfo && (
        <div
          style={{
            marginTop: details.content.rendered ? '0.5rem' : undefined,
          }}
        >
          <FileViewRedirectButton
            teamId={teamId}
            fileInfo={details.content.fileInfo}
            exerciseId={exerciseId}
            inInstructor={inInstructor}
          />
        </div>
      )}
    </div>
  )
)

export default ToolContent
