import FileViewRedirectButton from '@/components/FileViewRedirectButton'
import { css } from '@emotion/css'
import type { InjectDetails } from '@inject/graphql/fragments/InjectDetails.generated'
import { forwardRef } from 'react'

interface InjectContentProps {
  details: InjectDetails
  teamId: string
  exerciseId: string
  inInstructor: boolean
}

const removeFirst = css`
  & > *:first-child {
    margin-top: 0;
  }
`

// eslint-disable-next-line react/display-name
const InjectContent = forwardRef<HTMLDivElement, InjectContentProps>(
  ({ details, teamId, exerciseId, inInstructor }, ref) => (
    <>
      <div
        dangerouslySetInnerHTML={{
          __html: details.content.rendered,
        }}
        className={removeFirst}
        ref={ref}
      />
      {details.content.fileInfo && (
        <div
          style={{
            marginTop: details.content.rendered ? '0.5rem' : undefined,
          }}
        >
          <FileViewRedirectButton
            teamId={teamId}
            fileInfo={details.content.fileInfo}
            exerciseId={exerciseId}
            inInstructor={inInstructor}
          />
        </div>
      )}
    </>
  )
)

export default InjectContent
