import FileViewRedirectButton from '@/components/FileViewRedirectButton'
import type { EmailDetails } from '@inject/graphql/fragments/EmailDetails.generated'
import { forwardRef } from 'react'

interface EmailContentProps {
  details: EmailDetails
  teamId: string
  exerciseId: string
  inInstructor: boolean
}

// eslint-disable-next-line react/display-name
const EmailContent = forwardRef<HTMLDivElement, EmailContentProps>(
  ({ details, teamId, exerciseId, inInstructor }, ref) => (
    <>
      <div
        dangerouslySetInnerHTML={{
          __html: details.content.rendered,
        }}
        ref={ref}
      />
      {details.content.fileInfo && (
        <div
          style={{
            marginTop: details.content.rendered ? '0.5rem' : undefined,
          }}
        >
          <FileViewRedirectButton
            teamId={teamId}
            fileInfo={details.content.fileInfo}
            exerciseId={exerciseId}
            inInstructor={inInstructor}
          />
        </div>
      )}
    </>
  )
)

export default EmailContent
