import FileViewRedirectButton from '@/components/FileViewRedirectButton'
import type { CustomInjectDetails } from '@inject/graphql/fragments/CustomInjectDetails.generated'
import { forwardRef } from 'react'

interface CustomInjectContentProps {
  details: CustomInjectDetails
  teamId: string
  exerciseId: string
  inInstructor: boolean
}

// eslint-disable-next-line react/display-name
const CustomInjectContent = forwardRef<
  HTMLDivElement,
  CustomInjectContentProps
>(({ details, teamId, exerciseId, inInstructor }, ref) => (
  <>
    <div
      dangerouslySetInnerHTML={{
        __html: details.content.rendered,
      }}
      ref={ref}
    />
    {details.content.fileInfo && (
      <div
        style={{
          marginTop: details.content.rendered ? '0.5rem' : undefined,
        }}
      >
        <FileViewRedirectButton
          teamId={teamId}
          fileInfo={details.content.fileInfo}
          exerciseId={exerciseId}
          inInstructor={inInstructor}
        />
      </div>
    )}
  </>
))

export default CustomInjectContent
