General overview:
- All components has to use React Hooks, it's highly discouraged to use legacy React Components. Exception to this rule are Pure Components, but they're an advanced feature of React (be careful what you wish for)
- Code should be split up appropriately to their respective folders
- Guidelines have a scoped relationship, i.e. the guidelines apply to all files in the folder and it's sub-folders recursively.
- For components we use library called `blueprintjs`, for styling we use clear `.css`
- For routing in React we use library called `react-router`
- For state management in React we use library called `react-redux`
- For graphQL communication in React we use library called `apollo-graphql` (internally called), `@apollo/client` (by import)
- For code legibility we use `eslint`, `eslint` is setup in accordance to AirBNB React rules and additional rules for better enforcement of React Hooks

React components:
- `.tsx` files should include only one component which is exported as `default`
- Components must follow two-step rule, first declare a function without exporting, then export the variable separately (this has performance and rebuild implications).
- Returning React HTML should not contain any inline Javascript code or functions, exception is applying Javascript variables containing rendered React Hook code, functions and code should be embedded before return

General HTML/CSS/JS practices:
- It's highly encouraged to use latest HTML/CSS features in replacement to existing web development trends (Modals, Dialogs, Popovers)
- It's highly discouraged to use JS implementations to functions which are already supported natively by HTML/CSS, if such code arises somewhere please raise an issue to it

CSS:
- CSS classnames should be named uniquely in respect to it's use-case, i.e. UploadForm__label
- CSS classname "space" == "__"
- CSS parameters should maximize usage of variables, i.e. for sizings, colors, etc. These variables must be defined in the root and in index.css file in the root directory.

React component file/folder placement:
- One component folder is one `public` component which is imported as default `ListItem` to the folder
- Any dependent `private` components to a `public` component should reside together with related public component

Configuration:
- `config.ts` should contain global strings related to the overall configuration of the frontend, i.e. host endpoints