#!/bin/bash

# Script serves as an aid for generating the necessary Certbot certificates

CERTBOT_EMAIL=$1
INJECT_DOMAIN=$2

if [[ ! $# -eq 2 ]]; then
    echo "./cert_script.sh EMAIL_ADDRESS INJECT_DOMAIN"
    exit -1
fi

if [[ $(docker compose ps -q | wc -l ) -gt 0 ]]; then
    echo "Please ensure that the Docker compose is shut down via `docker compose down`"
    exit -2
fi

echo "[INJECT] Requesting CertBot for certificate"
docker run -p 80:80 -v ./certbot/conf/:/etc/letsencrypt/ --rm -it certbot/certbot:latest certonly --standalone --email $CERTBOT_EMAIL --agree-tos --no-eff-email --force-renewal -d $INJECT_DOMAIN