import type { CodegenConfig } from '@graphql-codegen/cli'

const config: CodegenConfig = {
  schema: ['schemas/schema.json', 'schemas/*.graphql'],
  documents: [
    'gql-cache/**/*.graphql',
  ],
  verbose: true,
  noSilentErrors: true,
  ignoreNoDocuments: true, // for better experience with the watcher
  config: {
    scalars: {
      DateTime: 'string',
    },
    skipTypename: true,
    avoidOptionals: true,
    enumsAsTypes: true,
    futureProofEnums: true,
    dedupeFragments: true,
    dedupeOperationSuffix: true,
    useTypeImports: true,
  },
  generates: {
    './generated/graphql.schema.json': {
      plugins: ['introspection'],
      config: {
        minify: false,
      },
    },
    './gql-cache/types.ts': {
      config: {
        useIndexSignature: true,
        showUnusedMappers: false,
        avoidOptionals: false,
        nonOptionalTypename: true,
        resolversNonOptionalTypename: true,
      },
      plugins: [
        {
          add: {
            content: '/* eslint-disable */',
          },
        },
        {
          add: {
            content: '//@ts-nocheck',
          },
        },
        'typescript',
        'typescript-resolvers',
      ],
    },
    './gql-cache/schema.ts': {
      plugins: [
        'typescript-operations',
        'typescript-react-apollo',
        {
          add: {
            content: '/* eslint-disable */',
          },
        },
        {
          add: {
            content: '//@ts-nocheck',
          },
        },
      ],
      preset: 'near-operation-file',
      presetConfig: {
        baseTypesPath: '../types.ts',
        importTypesNamespace: '_Types',
      },
      config: {
        documentMode: 'documentNode',
        withHooks: true,
        withHOC: false,
        withComponent: false,
        pureMagicComment: true,
        /*
         * addDocBlocks: true,
         * apolloReactHooksImportFrom: '@apollo/client',
         */
        reactApolloVersion: 3,
        omitOperationSuffix: true,
      },
    },
    './generated/client/apollo-helpers.ts': {
      plugins: [
        {
          add: {
            content: '/* eslint-disable */',
          },
        },
        {
          add: {
            content: '//@ts-nocheck',
          },
        },
        'typescript-apollo-client-helpers',
      ],
      config: {
        useTypeImports: true,
      },
    },
  },
}

export default config
