# Frontend (React)

Monorepo of INJECT Frontend

Subrepos:

- frontend - Main repository hosting Vite-related code, main components specific to INJECT Frontend
- graphql - Library for the communication with the GraphQL-based backend. Library is specifically made to easen development of GraphQL centric code to ensure higher consistency of queries.
- shared - Shared Library between all parts of the project containing functional and templating components
- tests - Service repo for testing typescript functions handling some algorithmic things
- backend - Git submodule with the currently supported backend, in the context of the release model this folder is not used. Prefer using tagged releases.

## How to run

To ensure the frontend application functions properly, it's necessary to have a backend instance up and running. Proceed with the installation steps for frontend outlined in [INSTALLATION.md](INSTALLATION.md).

To run the frontend, you have two options, each with its own set of requirements. The first method utilizes [yarn](#running-with-yarn) and is mostly used for development setup, while the second employs [Docker](INSTALLATION.md).

## Running with yarn

To run the frontend application using yarn, ensure you have the following prerequisites:

* [Node 20 LTS](https://nodejs.org/en)
* [Yarn](https://yarnpkg.com/)

Further make sure that the backend server is running. Make sure to set its address in `src/config.ts` and also in the backend's `KNOWN_HOSTS`.

Once you have these installed and everything configured, follow these steps:

First run the following command to install project dependencies:
```
yarn
```
Then run the frontend development server:
```
yarn dev
```
If you're on Windows, ensure that Git is installed and run the command in GitBash:
```
GIT_ENABLED=1 yarn dev
```

If you want to build the app for deployment, then follow these steps.

Compile the graphql and shared library:
```
yarn prebuild
```
Then build the `dist/` artifact from the frontend repository:
```
yarn build
```

## Live Environment

Monorepo contains a specialized Docker compose which aids in easier development of either frontend or backend. This compose is located in folder `docker/live-env/`. To run the compose you may start with `docker compose up`, to shut down `docker compose down`. For headless mode `docker compose up -d`.

Live Environment pre-generates logins on initialization and has persistent storage enabled. Logins are following:
- `t_staff@t.com` (Instructor)
- `t_user@t.com` (User)
- `t_super@t.com` (Superuser)

Password for all accounts is `t`. To access the deployment, it's located under `inject.localhost` localhost domain.

Live Environment has issues on WSL2/Windows Docker deployment with hot reloading of code, on Linux it should work. Please mind that the deployment runs development builds of IXP, not production. Thus in some cases it may not show certain bugs which are present in production builds.

To test out production environment it's adviced to use Nginx deployment for non-HTTPS deployment and set `INJECT_DOMAIN` to `inject.localhost`. This deployment fully replicates how the production environment runs.

## Generating Codegen headers

To aid in development and work with GraphQL, the project uses a tool called Codegen, which pulls the API described by the GraphQL Schema and generates appropriate Typescript library files that can be used with the project.

This tool needs to be executed every time when it's expected that there are changes in the GraphQL API with which the Frontend is compatible. Say updating the linked backend and having a new feature. To do it, it's needed to execute a script located at `docker/schema-gen/update.sh`. It's expected that the machine has Docker installed with support for Docker Compose (prior versions didn't bundle in Docker Compose to base Docker installation, latest versions of Docker have Docker Compose).

## How to update Frontend to support newer version of Backend

1. Update `backend` git submodule to desired commit
2. Generate Codegen headers via `docker/schema-gen/update.sh`
3. If headers change (signifying new behaviour), please revalidate if application works and fix it
4. Done, don't forget to mark your MR with [x] that the MR is tested with new backend

## How to test the Monorepo

Run `yarn test`, the tests should take no more than a minute now.

Currently the testing toolchain is still not very sufficient, this will be remedied in the future. 

## Project QC Features

The code uses a set of ESLint and Prettier rules to improve legiblity and enforce some React conventions.

The repo is littered with various README.md and GUIDELINES.md files that dictate rules of the repository. Rules are enforced during MRs

## Currently used libraries

- Ahooks (implements common React Hooks for general usage)
- Generouted (allows for easier creation of router configuration)
- GraphQL Codegen (allows for automatic typing of GraphQL queries)
- BlueprintJS (for UI)
- emotion CSS (for CSS-in-JS and type control)

## Usage of the repository in documentation

Parts of this repository are used automatically via a pipeline in the INJECT documentation. For more details, see the script that downloads and handles these files: [utilities.sh](https://gitlab.fi.muni.cz/inject/inject-docs/-/blob/main/utilities.sh?ref_type=heads). Some `.md` files may also include an attribute in the frontmatter `tags: used_in_docs` to indicate that they are used in the docs.