## Installation Guide (Docker)

### Local Variables (for Frontend setup)

- `VITE_HTTPS_HOST`: _string, default=undefined, example: ixp-instance-1.fi.muni.cz_ - Defines the HTTPS host for which the frontend application should connect to, the hostname should point to an instance of Backend application.

### Quick Setup

Please refer to `docker/nginx/` folder of the repository to see setup instruction for Docker/Nginx deployment.

The current configuration of IXP does not allow using mixed origins or mixed hostnames. That means Frontend and Backend services must be deployed at the identical host (domain and IP address) and must use the identical protocol (HTTPS). The most trivial solution is using **Docker Nginx** setup.

It's disallowed to use HTTP in your reverse proxy setup, the client uses APIs which are only available in [Secure Context](https://developer.mozilla.org/en-US/docs/Web/Security/Secure_Contexts), which may cause unstable behavior of the application without HTTPS.

### Building the image

To build a container image, please execute this command:

```bash
docker build . -t gitlab.fi.muni.cz/inject/frontend 
```

To run the image, use the following command, will run the Docker container listening on port 80.

```bash
docker run -d -p 80:80 -e VITE_HTTPS_HOST=secure-be.inject.muni.cz gitlab.fi.muni.cz/inject/frontend
```

Please keep in mind that changing environment variables requires restarting the container if done during runtime.
