import { Button } from '@blueprintjs/core'
import { useTranslation } from '@cyntler/react-doc-viewer/dist/esm/hooks/useTranslation'
import { PDFContext } from '@cyntler/react-doc-viewer/dist/esm/renderers/pdf/state'
import { setCurrentPage } from '@cyntler/react-doc-viewer/dist/esm/renderers/pdf/state/actions'
import { css } from '@emotion/css'
import { useContext } from 'react'

const pdfPagination = css`
  display: flex;
  gap: 1rem;
  justify-content: center;
  align-items: center;
`

const PDFPagination = () => {
  const {
    state: { currentPage, numPages },
    dispatch,
  } = useContext(PDFContext)
  const { t } = useTranslation()

  return (
    <div className={pdfPagination}>
      <Button
        id='pdf-pagination-prev'
        onClick={() => dispatch(setCurrentPage(currentPage - 1))}
        disabled={currentPage === 1}
        icon='chevron-left'
        title='Previous page'
        minimal
      />

      <span id='pdf-pagination-info'>
        {t('pdfPluginPageNumber', {
          currentPage,
          allPagesCount: numPages,
        })}
      </span>

      <Button
        id='pdf-pagination-next'
        onClick={() => dispatch(setCurrentPage(currentPage + 1))}
        disabled={currentPage >= numPages}
        icon='chevron-right'
        title='Next page'
        minimal
      />
    </div>
  )
}

export default PDFPagination
