import { Button, ButtonGroup, Card, Divider } from '@blueprintjs/core'
import { PDFContext } from '@cyntler/react-doc-viewer/dist/esm/renderers/pdf/state'
import {
  setPDFPaginated,
  setZoomLevel,
} from '@cyntler/react-doc-viewer/dist/esm/renderers/pdf/state/actions'
import { css } from '@emotion/css'
import { useContext } from 'react'
import PDFPagination from './PDFPagination'

const pdfcontrol = css`
  display: flex;
  justify-content: space-between;
  padding: 0.5rem;
`

const buttonGroup = css`
  display: flex;
  justify-content: center;
`

const viewToggle = css`
  display: flex;
  gap: 1rem;
  align-items: center;
`

const PDFControls = () => {
  const {
    state: { paginated, zoomLevel, numPages, zoomJump, defaultZoomLevel },
    dispatch,
  } = useContext(PDFContext)

  return (
    <Card id='pdf-controls' className={pdfcontrol}>
      <div className={viewToggle}>
        {numPages > 1 && (
          <Button
            id='pdf-toggle-pagination'
            onMouseDown={() => dispatch(setPDFPaginated(!paginated))}
            icon={paginated ? 'sort' : 'duplicate'}
            minimal
            text={
              paginated
                ? 'Switch to continuos scroll'
                : 'Switch to paginated view'
            }
            title={
              paginated
                ? 'Switch to continuous scroll'
                : 'Switch to paginated view'
            }
          />
        )}
        {paginated && numPages > 1 && <PDFPagination />}
      </div>

      <ButtonGroup minimal className={buttonGroup}>
        <Button
          id='pdf-zoom-out'
          onMouseDown={() => dispatch(setZoomLevel(zoomLevel - zoomJump))}
          icon='zoom-out'
          title='Zoom out'
        />
        <Button
          id='pdf-zoom-in'
          onMouseDown={() => dispatch(setZoomLevel(zoomLevel + zoomJump))}
          icon='zoom-in'
          title='Zoom in'
        />
        <Divider />
        <Button
          id='pdf-zoom-reset'
          onMouseDown={() => dispatch(setZoomLevel(defaultZoomLevel))}
          disabled={zoomLevel === defaultZoomLevel}
          icon='zoom-to-fit'
          title='Zoom to fit'
        />
      </ButtonGroup>
    </Card>
  )
}

export default PDFControls
