import { PDFContext } from '@cyntler/react-doc-viewer/dist/esm/renderers/pdf/state'
import type { FC } from 'react'
import { useContext } from 'react'
import PDFSinglePage from './PDFSinglePage'

interface Props {
  pageNum?: number
}

const PDFAllPages: FC<Props> = () => {
  const {
    state: { numPages },
  } = useContext(PDFContext)

  const PagesArray = []
  for (let i = 0; i < numPages; i++) {
    PagesArray.push(<PDFSinglePage key={i + 1} pageNum={i + 1} />)
  }

  return PagesArray
}

export default PDFAllPages
