import type { DocRenderer } from '@cyntler/react-doc-viewer'
import { PDFProvider } from '@cyntler/react-doc-viewer/dist/esm/renderers/pdf/state'
import { css } from '@emotion/css'
import { pdfjs } from 'react-pdf'
import PDFControls from './PDFControls'
import PDFPages from './PDFPages'

import 'react-pdf/dist/esm/Page/AnnotationLayer.css'
import 'react-pdf/dist/esm/Page/TextLayer.css'

// @ts-expect-error
import pdfWorker from 'pdfjs-dist/build/pdf.worker.min.js?url'
// this needs to be ignored, don't ask me why, typescript is just being a pain

const container = css`
  display: flex;
  flex-direction: column;
  flex: 1;
  overflow-y: auto;
  gap: 1rem;
`

pdfjs.GlobalWorkerOptions.workerSrc = pdfWorker

// eslint-disable-next-line react/prop-types
const PDFRenderer: DocRenderer = ({ mainState }) => (
  <PDFProvider mainState={mainState}>
    <div className={container} id='pdf-renderer' data-testid='pdf-renderer'>
      <PDFControls />
      <PDFPages />
    </div>
  </PDFProvider>
)

export default PDFRenderer

PDFRenderer.fileTypes = ['pdf', 'application/pdf']
PDFRenderer.weight = 0
