import Keys from '../localstorage/keys'

const authenticatedFetch = async (...params: Parameters<typeof fetch>) => {
  const [url, _options] = params
  const options = _options || {}
  if (!(options?.headers instanceof Headers)) {
    options.headers = new Headers(options?.headers)
  }
  if (!options.credentials) {
    options.credentials = 'include'
  }
  options.headers.set('session-id', localStorage.getItem(Keys.SESSION_ID) || '')

  // make request
  return fetch(url, options)
}

export default authenticatedFetch
