import type { Placement } from '@floating-ui/react'
import { autoUpdate, offset, shift, useFloating } from '@floating-ui/react'

const usePopover = (
  open: boolean,
  onOpenChange: (open: boolean, event?: Event) => void,
  placement: Placement = 'bottom'
) =>
  useFloating({
    open,
    placement,
    middleware: [
      shift({
        padding: 10,
      }),
      offset(20),
    ],
    onOpenChange,
    whileElementsMounted: autoUpdate,
  })

export default usePopover
