import type { Intent, ToastProps } from '@blueprintjs/core'
export interface BroadcastToastProps
  extends Omit<ToastProps, 'onDismiss' | 'message'> {
  timestamp: number
  id: string
  message: string
}
export interface NotificationProps {
  msg: string
  intent: Intent
  timestamp: number
}

export interface OmittedToastProps
  extends Omit<ToastProps, 'onDismiss' | 'message'> {
  message?: string
}

export type NotifyFunction = (
  msg: string,
  toastProps?: OmittedToastProps,
  timestamp?: Date
) => void
