const READ_RECEIPT = 'read-receipt'

const Keys = {
  // settings
  GRAPHIQL_CONFIRMED: 'graphiql-confirmed',
  VOYAGER_CONFIRMED: 'voyager-confirmed',
  DARK_MODE: 'dark-mode',
  NOTIFICATIONS: 'notifications',
  NOTIFICATION_LIMIT: 'notification-limit',
  SYSTEM_NOTIFICATIONS: 'system-notifications',
  HAS_FOCUS: 'has-focus',
  EXPERIMENTAL_ALLOWED: 'experimental-allowed',
  RELATIVE_TIME: 'relative-time',
  INSTRUCTOR_TEAMS: 'instructor-teams',

  // connection
  HOST: 'host',
  WS_PATH: 'ws-path',

  // read receipt
  getReadReceiptEmailKey: (id: string) => READ_RECEIPT.concat(`:email:${id}`),
  getReadReceiptEmailThreadKey: (id: string) =>
    READ_RECEIPT.concat(`:email-thread:${id}`),
  getReadReceiptActionLogKey: (id: string) =>
    READ_RECEIPT.concat(`:action-log:${id}`),
  getReadReceiptChannelKey: (id: string) =>
    READ_RECEIPT.concat(`:channel:${id}`),
  getActionLogTodoKey: (id: string) =>
    READ_RECEIPT.concat(`:actionLogTodo:${id}`),
  getEmailTodoKey: (id: string) => READ_RECEIPT.concat(`:emailTodo:${id}`),
  getQuestionnaireTodoKey: (id: string, teamId: string) =>
    READ_RECEIPT.concat(`:questionnaireTodo:${id}-${teamId}`),
  getEmailThreadArchiveKey: (id: string) =>
    READ_RECEIPT.concat(`:emailThreadArchive:${id}`),

  // auth
  SESSION_ID: 'session-id',

  // email drafts
  getEmailDraftsKey: (teamId: string, instructor: boolean) =>
    `email-drafts:${teamId}${instructor ? '-instructor' : ''}`,

  // other
  HIDE_SIDEBAR: 'hide-sidebar',
  getQuestionnaireAnswersKey: (id: string) => `questionnaire-answers:${id}`,
}

export default Keys
