import DocViewer from '@cyntler/react-doc-viewer'
import { useEffect, type FC } from 'react'
import type { RendererProps } from '../../types'
import LoadingRenderer from './LoadingRenderer'
import PDFPluginRenderer from './PDFPluginRenderer'
import './viewer.global.css'

const PDFRenderer: FC<RendererProps> = ({ doc }) => {
  useEffect(() => {
    ;(
      document.getElementById('pdf-renderer')?.querySelectorAll('a') || []
    ).forEach(x => {
      x.setAttribute('target', '_blank')
    })
  }, [doc])

  return (
    <DocViewer
      documents={[doc]}
      pluginRenderers={[PDFPluginRenderer]}
      config={{
        pdfVerticalScrollByDefault: true,
        loadingRenderer: { overrideComponent: LoadingRenderer },
        header: {
          overrideComponent: () => <></>,
        },
      }}
    />
  )
}

export default PDFRenderer
