import { useEffect, type FC } from 'react'
import type { RendererProps } from '../types'

const NotSupportedRenderer: FC<RendererProps> = ({ doc }) => {
  useEffect(() => {
    const link = document.createElement('a')
    link.href = doc.uri
    link.download = doc.fileName
    document.body.appendChild(link)
    link.click()
    document.body.removeChild(link)

    if (window.history.length > 1) {
      window.history.back()
    } else {
      window.close()
    }
  }, [doc.fileName, doc.uri])

  return <></>
}

export default NotSupportedRenderer
