import { css, cx } from '@emotion/css'
import { forwardRef, type CSSProperties, type PropsWithChildren } from 'react'

const divContainer = css`
  width: 100%;
  margin: 0 auto;
  max-width: 60rem;

  @media (max-width: 60rem) {
    padding-left: 1rem;
    padding-right: 1rem;
  }
`

interface ContainerProps extends PropsWithChildren {
  //@deprecated
  makeFullHeight?: boolean
  style?: CSSProperties
  className?: string
  id?: string
}

const Container = forwardRef<HTMLDivElement, ContainerProps>(function Container(
  { children, style, className, id },
  ref
) {
  return (
    <div
      className={cx(divContainer, className)}
      style={style}
      ref={ref}
      id={id}
    >
      {children}
    </div>
  )
})

export default Container
