import { useTypedQuery, useTypedSubscription } from '../graphql'
import { GetTeamMilestones } from '../queries'
import { teamMilestones } from '../subscriptions'

const useTeamMilestonesSubscription = (teamId: string) => {
  useTypedQuery({
    query: GetTeamMilestones,
    variables: {
      teamId,
    },
  })
  useTypedSubscription({
    query: teamMilestones,
    variables: {
      teamId,
    },
  })
}

export default useTeamMilestonesSubscription
