import { useEffect } from 'react'
import { useClient } from 'urql'
import { useTypedQuery } from '../graphql'
import { GetExercises } from '../queries'
import { exercises } from '../subscriptions'

const useExercisesSubscription = () => {
  const query = useTypedQuery({
    query: GetExercises,
    requestPolicy: 'network-only',
  })
  const client = useClient()

  useEffect(() => {
    const { unsubscribe } = client.subscription(exercises, {}).subscribe(e => {
      console.log('exercise event: ', e)
    })

    return () => {
      unsubscribe()
    }
  }, [client])

  return query
}

export default useExercisesSubscription
